{* Calculate title from path *}
{capture name="title"}
   {if count($path) > 1} - {/if}
   {foreach from=$path item=category name=path}
      {if $smarty.foreach.path.iteration gt 2}
         >
      {/if}
      {if not $smarty.foreach.path.first}
         {$category.TITLE}
      {/if}
   {/foreach}
{/capture}
{strip}
{if $title_prefix}
   {assign var="in_page_title" value=$title_prefix|cat:$category.TITLE}
{else}
   {assign var="in_page_title" value=$category.TITLE}
{/if}
{assign var="description" value=$category.DESCRIPTION}

{include file="header.tpl"}
{include file="top_bar.tpl"}


{* Calculate the number of categories per row *}
   {php}
      $this->assign('cats_per_col', ceil(count($this->get_template_vars('categs')) / CATS_PER_ROW));
   {/php}
{if $cats_per_col > 15}
   {php}
      $this->assign('cats_per_col', ceil(count($this->get_template_vars('categs')) / (CATS_PER_ROW + 1)));
   {/php}
{/if}

	
{* Show category search results *}
{if $search_category}
   {$search_category}
{/if}

{if isset($have_search_results) and $have_search_results == 0}
   <div class="navmenu">
      <p>{l}Sorry, no records found that match your keyword(s){/l}: "{$search|escape|wordwrap:200:"\n":true}"</p>
      <p>{l}Suggestions{/l}:</p>
      <p>
         <ul>
            <li>{l}Make sure all words are spelled correctly{/l}.</li>
            <li>{l}Try different keywords{/l}.</li>
            <li>{l}Try more general keywords{/l}.</li>
         </ul>
      </p>
   </div>
{/if}

{* Categories *}
{if !empty($categs)}
	
	
<div class="topmid">
   <div class="browsed"><div></div></div></div>
<table width="100%" border="0" cellpadding="0" cellspacing="0"
style="background:#A88F49">
  <tr>
    <td width="14px" class="roundleft">&nbsp</td>

	<td>
<br />

{* Categories *}

<table border="0px" cellpadding="0" cellspacing="0" width="98%" style="margin: 0 auto">
<tr>
{foreach from=$categs item=cat name=categs}
   {if ($smarty.foreach.categs.iteration mod $cats_per_col eq 1 and $cats_per_col gt 1) or $smarty.foreach.categs.first}<td valign="top"{if $category.ID==0} {/if}>{/if}

{* Start Categories Modifications By Vegabond *}

{if $category.ID==0}<div class="cat_box">
<div class="cat"><a href="{if $smarty.const.ENABLE_REWRITE}{$cat.TITLE_URL|escape}/{else}index.php?c={$cat.ID}{/if}">{$cat.TITLE|escape}</a>{if $smarty.const.CATS_COUNT} <font size="1">({$cat.COUNT})</font>{/if}</div>


{* Display subcategories *}

{if !empty($cat.SUBCATS)}
{foreach from=$cat.SUBCATS item=scat name=scategs}
<div class="subcat">
         
            <a href="{if $smarty.const.ENABLE_REWRITE}{$cat.TITLE_URL|escape}/{$scat.TITLE_URL|escape}/{else}index.php?c={$scat.ID}{/if}">
            {$scat.TITLE|escape}</a>
</div>
{/foreach}</div><div class="catdot"></div>
{/if}

{else}
<div class="subcat"><a href="{if $smarty.const.ENABLE_REWRITE}{$cat.TITLE_URL|escape}/{else}index.php?c={$cat.ID}{/if}">{$cat.TITLE|escape}</a>{if $smarty.const.CATS_COUNT} <font size="1">({$cat.COUNT})</font>{/if}</div>


{/if}


{* End Categories Modifications By Vegabond *}

{if ($smarty.foreach.categs.iteration mod $cats_per_col eq 0 and $cats_per_col gt 1) or $smarty.foreach.categs.last}</td>{/if}
{/foreach}
</tr></table>

</td>

     <td width="14px" class="roundright">&nbsp</td>
</tr>
</table>
   <div class="botmid">
<div class="bottom"><div></div></div>
</div>
<br />

{/if}

{if $smarty.const.FTR_ENABLE == 1 and !empty($feat_links)}


<div class="topmid">
   <div class="featured"><div></div></div></div>
<table width="100%" border="0" cellpadding="0" cellspacing="0"
style="background:#A88F49">
  <tr>
    <td width="14px" class="roundleft">&nbsp</td>

	<td>


<table width="98%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr>
   <td>
       {foreach from=$feat_links item=link name=links}
       <div class="f_link">{include file="f.link.tpl" link=$link}</div>
       {/foreach}    
   </td>
</tr>
</table>
<div class="break"></div>

</td>

     <td width="14px" class="roundright">&nbsp</td>
</tr>
</table>
   <div class="botmid">
<div class="bottom"><div></div></div>
</div>
</div>
<br />
{/if}

{* Links heading and sorting*}
{if ($uid || $search || !empty($category.ID) || $list) && !empty($links)}

<div class="topmid"><table width="100%" border="0" cellpadding="0" cellspacing="0"><tr><td><img src="{$smarty.const.DOC_ROOT}/templates/{$smarty.const.USE_TEMPLATE}/images/standard.gif"  /></td>

<td>
   

<div id="bar">	
{if not $list}<div class="sort">{l}Sort by{/l}:
   {if $smarty.const.ENABLE_PAGERANK and $smarty.const.SHOW_PAGERANK}{if $sort eq 'P'} {l}PageRank{/l}{else} <a href="?s=P{if !empty($p)}&amp;p={$p}{/if}{if not $smarty.const.ENABLE_REWRITE}&amp;c={$category.ID}{/if}{if $search}&amp;search={$search}{/if}{if $uid}&amp;uid={$uid}{/if}"> {l}PageRank{/l}</a>{/if} |{/if}
   {if $sort eq 'H'} {l}Hits{/l}{else} <a href="?s=H{if !empty($p)}&amp;p={$p}{/if}{if not $smarty.const.ENABLE_REWRITE}&amp;c={$category.ID}{/if}{if $search}&amp;search={$search}{/if}{if $uid}&amp;uid={$uid}{/if}">{l}Hits{/l}</a>{/if}
   {if $sort eq 'A'} | {l}Alphabetical{/l}{else} | <a href="?s=A{if !empty($p)}&amp;p={$p}{/if}{if not $smarty.const.ENABLE_REWRITE}&amp;c={$category.ID}{/if}{if $search}&amp;search={$search}{/if}{if $uid}&amp;uid={$uid}{/if}">{l}Alphabetical{/l}</a>{/if}
   </div>{/if}
   </div>
</td>
<td align="right"><img src="{$smarty.const.DOC_ROOT}/templates/{$smarty.const.USE_TEMPLATE}/images/roundedcornr_787882_tr.gif"  /></td>

</tr>
</table>


</div>
<table width="100%" border="0" cellpadding="0" cellspacing="0"
style="background:#A88F49">
  <tr>
    <td width="14px" class="roundleft">&nbsp</td>

	<td>

<table width="98%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr>
   <td valign="top">
{foreach from=$links item=link name=links}
  <div class="f_link">{include file="link.tpl" link=$link}</div>
{/foreach}
   </td>
</tr>
</table>

</td>

     <td width="14px" class="roundright">&nbsp</td>
</tr>
</table>
   <div class="botmid">
<div class="bottom"><div></div></div>
</div>
</div>
<br />
{/if}



{if !empty($articles) and !$uid and !$search}

<div class="topmid">
   <div class="recent"><div></div></div></div>
<table width="100%" border="0" cellpadding="0" cellspacing="0"
style="background:#A88F49">
  <tr>
    <td width="14px" class="roundleft">&nbsp</td>

	<td>


<div id="bar">
      

{foreach from=$articles item=article name=name}
<br />
<table border="0" cellspacing="0px" style="border-collapse: collapse" width="100%" cellpadding="5px" onmouseover="this.style.backgroundColor='#AF9651'" onmouseout="this.style.backgroundColor='transparent'">
    <tr>
      <td width="100%">{include file="articlelink.tpl" link=$article}</td>
    </tr>
  </table>

      {/foreach}

      </div>
</td>

     <td width="14px" class="roundright">&nbsp</td>
</tr>
</table>
   <div class="botmid">
<div class="bottom"><div></div></div>
</div>
</div>
<br />

{/if}

{* Javascript for tracking link clicks *}
{if $StopLinkHits eq 0}
   <script language="javascript" type="text/javascript">
   /* <![CDATA[ */
      var root = '{$smarty.const.DOC_ROOT}';
      {literal}
      var a = document.getElementsByTagName("a");
      for(i = 0; i< a.length; i++)
         if(a[i].id != '')
            a[i].onclick = count_link;
      function count_link() {
         i = new Image();
         i.src= root+'/cl.php?id='+this.id;
         return true;
      }
      {/literal}
   /* ]]> */
   </script>
{/if}

{include file="footer.tpl"}
{/strip}